/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analyzer.sensor;

import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.ClassUtils;
import org.sonar.api.batch.CheckProject;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.dag.DirectAcyclicGraph;
import org.sonarsource.sonarlint.core.analyzer.sensor.DefaultSensorContext;
import org.sonarsource.sonarlint.core.analyzer.sensor.SensorOptimizer;
import org.sonarsource.sonarlint.core.analyzer.sensor.SensorWrapper;
import org.sonarsource.sonarlint.core.container.ComponentContainer;
import org.sonarsource.sonarlint.core.container.global.ExtensionMatcher;

public class BatchExtensionDictionnary {
    private final ComponentContainer componentContainer;
    private final SensorContext sensorContext;
    private final SensorOptimizer sensorOptimizer;

    public BatchExtensionDictionnary(ComponentContainer componentContainer, DefaultSensorContext sensorContext, SensorOptimizer sensorOptimizer) {
        this.componentContainer = componentContainer;
        this.sensorContext = sensorContext;
        this.sensorOptimizer = sensorOptimizer;
    }

    public <T> Collection<T> select(Class<T> type, @Nullable Project project, boolean sort, @Nullable ExtensionMatcher matcher) {
        List<T> result = this.getFilteredExtensions(type, project, matcher);
        if (sort) {
            return this.sort(result);
        }
        return result;
    }

    private static Phase.Name evaluatePhase(Object extension) {
        Object extensionToEvaluate = extension instanceof SensorWrapper ? ((SensorWrapper)extension).wrappedSensor() : extension;
        Phase phaseAnnotation = AnnotationUtils.getAnnotation(extensionToEvaluate, Phase.class);
        if (phaseAnnotation != null) {
            return phaseAnnotation.name();
        }
        return Phase.Name.DEFAULT;
    }

    private <T> List<T> getFilteredExtensions(Class<T> type, @Nullable Project project, @Nullable ExtensionMatcher matcher) {
        ArrayList<Object> result = Lists.newArrayList();
        for (Object extension : this.getExtensions(type)) {
            if (org.sonar.api.batch.Sensor.class.equals(type) && extension instanceof Sensor) {
                extension = new SensorWrapper((Sensor)extension, this.sensorContext, this.sensorOptimizer);
            }
            if (!BatchExtensionDictionnary.shouldKeep(type, extension, project, matcher)) continue;
            result.add(extension);
        }
        if (org.sonar.api.batch.Sensor.class.equals(type)) {
            for (Object extension : this.getExtensions(Sensor.class)) {
                if (!BatchExtensionDictionnary.shouldKeep(type, extension = new SensorWrapper((Sensor)extension, this.sensorContext, this.sensorOptimizer), project, matcher)) continue;
                result.add(extension);
            }
        }
        return result;
    }

    protected List<Object> getExtensions(Class type) {
        ArrayList<Object> extensions = Lists.newArrayList();
        BatchExtensionDictionnary.completeBatchExtensions(this.componentContainer, extensions, type);
        return extensions;
    }

    private static void completeBatchExtensions(ComponentContainer container, List<Object> extensions, Class type) {
        if (container != null) {
            extensions.addAll(container.getComponentsByType(type));
            BatchExtensionDictionnary.completeBatchExtensions(container.getParent(), extensions, type);
        }
    }

    public <T> Collection<T> sort(Collection<T> extensions) {
        DirectAcyclicGraph dag = new DirectAcyclicGraph(new Object[0]);
        for (T extension : extensions) {
            dag.add(extension, new Object[0]);
            for (Object dependency : this.getDependencies(extension)) {
                dag.add(extension, dependency);
            }
            for (Object generates : this.getDependents(extension)) {
                dag.add(generates, extension);
            }
            BatchExtensionDictionnary.completePhaseDependencies(dag, extension);
        }
        List sortedList = dag.sort();
        return Collections2.filter(sortedList, Predicates.in(extensions));
    }

    private <T> List<Object> getDependencies(T extension) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(this.evaluateAnnotatedClasses(extension, DependsUpon.class));
        return result;
    }

    public <T> List<Object> getDependents(T extension) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(this.evaluateAnnotatedClasses(extension, DependedUpon.class));
        return result;
    }

    private static void completePhaseDependencies(DirectAcyclicGraph dag, Object extension) {
        Phase.Name phase = BatchExtensionDictionnary.evaluatePhase(extension);
        dag.add(extension, new Object[]{phase});
        for (Phase.Name name : Phase.Name.values()) {
            if (phase.compareTo(name) < 0) {
                dag.add((Object)name, extension);
                continue;
            }
            if (phase.compareTo(name) <= 0) continue;
            dag.add(extension, new Object[]{name});
        }
    }

    protected List<Object> evaluateAnnotatedClasses(Object extension, Class<? extends Annotation> annotation) {
        ArrayList<Object> results = Lists.newArrayList();
        for (Class<?> aClass = extension.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            BatchExtensionDictionnary.evaluateClass(aClass, annotation, results);
            for (Method method : aClass.getDeclaredMethods()) {
                if (method.getAnnotation(annotation) == null) continue;
                BatchExtensionDictionnary.checkAnnotatedMethod(method);
                this.evaluateMethod(extension, method, results);
            }
        }
        return results;
    }

    private static void evaluateClass(Class extensionClass, Class annotationClass, List<Object> results) {
        Class<?>[] interfaces;
        Object annotation = extensionClass.getAnnotation(annotationClass);
        if (annotation != null) {
            if (annotation.annotationType().isAssignableFrom(DependsUpon.class)) {
                results.addAll(Arrays.asList(((DependsUpon)annotation).value()));
            } else if (annotation.annotationType().isAssignableFrom(DependedUpon.class)) {
                results.addAll(Arrays.asList(((DependedUpon)annotation).value()));
            }
        }
        for (Class<?> anInterface : interfaces = extensionClass.getInterfaces()) {
            BatchExtensionDictionnary.evaluateClass(anInterface, annotationClass, results);
        }
    }

    private void evaluateMethod(Object extension, Method method, List<Object> results) {
        try {
            Object result = method.invoke(extension, new Object[0]);
            if (result != null) {
                if (result instanceof Class) {
                    results.addAll(this.componentContainer.getComponentsByType((Class)result));
                } else if (result instanceof Collection) {
                    results.addAll((Collection)result);
                } else if (result.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(result); ++i) {
                        results.add(Array.get(result, i));
                    }
                } else {
                    results.add(result);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not invoke method " + method, e);
        }
    }

    private static void checkAnnotatedMethod(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalStateException("Annotated method must be public:" + method);
        }
        if (method.getParameterTypes().length > 0) {
            throw new IllegalStateException("Annotated method must not have parameters:" + method);
        }
    }

    private static boolean shouldKeep(Class type, Object extension, @Nullable Project project, @Nullable ExtensionMatcher matcher) {
        boolean keep;
        boolean bl = keep = (ClassUtils.isAssignable(extension.getClass(), type) || org.sonar.api.batch.Sensor.class.equals((Object)type) && ClassUtils.isAssignable(extension.getClass(), Sensor.class)) && (matcher == null || matcher.accept(extension));
        if (keep && project != null && ClassUtils.isAssignable(extension.getClass(), CheckProject.class)) {
            keep = ((CheckProject)extension).shouldExecuteOnProject(project);
        }
        return keep;
    }
}

